	[G, Z, P] = CH_I_POLES_Z2(Wc, Ws, Amax, Amin, N)
	
	% 	Computes the denormalized poles, zeros, and gain constant for  
	%	a digital lowpass Chevyshev I filter directly in the z-plane.
	%	The design margin is used to decrease the stopband edge.
	
	% 	Toolbox for DIGITAL FILTERS USING MATLAB
	
	% 	Author: 		Tapio Saramaki, 2018-03-08
	% 	Modified by: 	LW
	% 	Version: 		1
	% 	Known bugs:
	% 	Copyright:		by authors - not released for commercial use	
	% 	Report bugs to:	Wanhammar@gmail.com
	
	aconstant = tan(wcT/2); 
	epsilon = sqrt(10^(Amax/10)-1);
	gamma = (1+sqrt(1+epsilon^2))/epsilon;
	gamma = gamma^(1/N);
	gamma1 = -(gamma-1/gamma)/2;
	gamma2 = (gamma+1/gamma)/2;
	k = 1:N;
	a = (2*k-1)*pi/(2*N);
	pol = gamma1*sin(a)+j*gamma2*cos(a);
	P = (1+aconstant*pol)./(1-aconstant*pol);
	zero_angles(k) = pi;	
	Z = exp(j*zero_angles);
	G = 1;
	if rem(N,2) == 0 
		G = sqrt(10^(-Amax/10));
	end	
	G = G*real(prod(1-P))/real(prod(1-Z));
	
